/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.http.HTTPRequest;
import jade.imtp.leap.http.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class HTTPServerConnection
extends Connection {
    private Socket sc;
    private InputStream is;
    private OutputStream os;
    private boolean readAvailable;
    private boolean writeAvailable;

    public HTTPServerConnection(Socket s) {
        this.sc = s;
        this.readAvailable = true;
        this.writeAvailable = false;
    }

    public JICPPacket readPacket() throws IOException {
        if (this.readAvailable) {
            HTTPRequest request = new HTTPRequest();
            this.is = this.sc.getInputStream();
            request.readFrom(this.is);
            this.readAvailable = false;
            this.writeAvailable = true;
            if (request.getMethod().equals("GET")) {
                String recipientID = request.getField("recipient-id");
                JICPPacket pkt = new JICPPacket(23, 0, recipientID, null);
                return pkt;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(request.getPayload());
            return JICPPacket.readFrom(bis);
        }
        throw new IOException("Read not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePacket(JICPPacket pkt) throws IOException {
        if (this.writeAvailable) {
            int n;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int ret = pkt.writeTo(bos);
                HTTPResponse response = new HTTPResponse();
                response.setCode("200");
                response.setMessage("OK");
                response.setHttpType("HTTP/1.1");
                response.setPayload(bos.toByteArray());
                this.os = this.sc.getOutputStream();
                response.writeTo(this.os);
                this.os.flush();
                this.readAvailable = true;
                this.writeAvailable = false;
                n = ret;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return n;
        }
        throw new IOException("Write not available");
    }

    public void close() throws IOException {
        this.readAvailable = false;
        this.writeAvailable = false;
        try {
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        try {
            this.os.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.os = null;
        try {
            this.sc.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sc = null;
    }

    public String getRemoteHost() throws Exception {
        return this.sc.getInetAddress().getHostAddress();
    }
}

